normalize.AffyBatch.loesssubset <- function (abatch, stable.probes, ...) 
{
    stable.index <- unlist(indexProbes(abatch,"both")[stable.probes])
    Index <- unlist(indexProbes(abatch, "both"))
    tmp.stable <- which(is.element(Index,stable.index))
    intensity(abatch)[Index, ] <- normalize.loesssubset(intensity(abatch)[Index, ], subset = tmp.stable,sample.length=20000,maxit=4, ...)
    return(abatch)
}

# normalize only the PM probes (for RMA background correction).
normalize.AffyBatch.loesssubsetpm <- function (abatch, stable.probes, ...) 
{
    stable.index <- unlist(indexProbes(abatch,"pm")[stable.probes])
    Index <- unlist(indexProbes(abatch, "pm"))
    tmp.stable <- which(is.element(Index,stable.index))
    intensity(abatch)[Index, ] <- normalize.loesssubset(intensity(abatch)[Index, ], subset = tmp.stable,sample.length=20000,maxit=4, ...)
    return(abatch)
}

#normalize only the PM probes (for the regular loess function).
normalize.AffyBatch.loesspm <- function (abatch, ...) {
    Index <- unlist(indexProbes(abatch, "pm"))
    intensity(abatch)[Index, ] <- normalize.loess(intensity(abatch)[Index, 
        ], ...)
    return(abatch)
}

normalize.loesssubset <- function (mat, subset = sample(1:(dim(mat)[1]), min(c(5000, nrow(mat)))), 
    epsilon = 10^-2, maxit = 1, log.it = TRUE, verbose = TRUE, 
    span = 1/25, family.loess = "symmetric",sample.length=10000) 
{
  # decreased the span from 2/3 to 1/25.
  # the sample.length must be less than or equal to length(subset)
    J <- dim(mat)[2]
    II <- dim(mat)[1]
    newData <- mat
    if (log.it) {
        mat <- log2(mat)
        newData <- log2(newData)
    }
    change <- epsilon + 1
    fs <- matrix(0, II, J)
    iter <- 0
    while (iter < maxit) {
        iter <- iter + 1
        means <- matrix(0, II, J)
        subset <- sample(subset,sample.length)
        w <- c(0, rep(1, sample.length), 0)
        for (j in 1:(J - 1)) {
            for (k in (j + 1):J) {
              y <- newData[, j] - newData[, k]
              x <- (newData[, j] + newData[, k])/2
              index <- c(order(x)[1], subset, order(-x)[1])
              xx <- x[index]
              yy <- y[index]
              aux <- loess(yy ~ xx, span = span, degree = 2, 
                           weights = w, family = family.loess)
              aux <- predict(aux, data.frame(xx = x))/J
              means[, j] <- means[, j] + aux
              means[, k] <- means[, k] - aux
              if (verbose) {
                cat("Done with", j, "vs", k, " in iteration ", 
                    iter, "\tnumber in subset: ",length(index),"\n")
                tmp.xlab <- paste("M: chip ", j, " vs ", k,sep="")
                tmp.ylab <- paste("A: chip ", j, " vs ", k,sep="")
                tmp.main <- paste("Iteration = ", iter,sep="")
                plot(x,y,pch=".",xlab=tmp.xlab, ylab=tmp.ylab,main=tmp.main)
                points(xx,yy,pch=".",col="green")
                points(x,aux*J,col="orange",pch=".")
                abline(h=0,col="red")
              }
            }
        }
        fs <- fs + means
        newData <- mat - fs
        change <- max(apply((means[subset, ])^2, 2, mean))
        if (verbose) 
            cat(iter, change, "\n")
        oldfs <- fs
    }
    if ((change > epsilon) & (maxit > 1)) 
        warning(paste("No convergence after", maxit, "iterations.\n"))
    if (log.it) {
        return(2^newData)
    }
    else return(newData)
}

# this is a loess normalization for datasets with NA's... in this case we
# end up with having to do straight (not M vs A) normalization and
# using a reference chip to normalize against.
normalize.loesssubset.new <- function (mat, subset = sample(1:(dim(mat)[1]), min(c(5000, nrow(mat)))), refindex=1,
    epsilon = 10^-2, maxit = 1, log.it = TRUE, verbose = TRUE, 
    span = 2/3, family.loess = "symmetric") {
    J <- dim(mat)[2]
    II <- dim(mat)[1]
    newData <- mat
    if (log.it) {
        mat <- log2(mat)
        newData <- log2(newData)
        newData[is.nan(newData) | is.infinite(newData)] <- NA
    }
    change <- epsilon + 1
    fs <- matrix(0, II, J)
    iter <- 0
    w <- c(0, rep(1, length(subset)), 0)
    while (iter < maxit) {
        iter <- iter + 1
        means <- matrix(0, II, J)
        for (k in (1:J)[-refindex]) {
          y <- newData[, refindex]
          x <- newData[, k]
          tmp.index <- intersect(which(!is.na(x) & !is.na(y)),subset)
          index <- c(order(x)[1], tmp.index, order(-x)[1])
          w <- c(0,rep(1,length(tmp.index)),0)
          cat("Length of subset: ",length(tmp.index),"\n",sep="")
          xx <- x[index]
          yy <- y[index]
          aux <- loess(yy ~ xx, span = span, degree = 2, 
                       weights = w, family = family.loess,na.action="na.omit")
          cat("here")
          aux.2 <- predict(aux, data.frame(xx = x[!is.na(x)]))
          cat("there")
          newData[,k][!is.na(x)] <- aux.2
          cat("again")
          if (verbose) {
            cat("Done with", refindex, "vs", k, " in iteration ", 
                iter, "\tnumber in subset: ",length(index),"\n")
            tmp.xlab <- paste("chip ", refindex, ": Signal",sep="")
            tmp.ylab <- paste("chip ", k, ": Signal",sep="")
            tmp.main <- paste("Before Normalization", iter,sep="")
            plot(y,x,pch=".",xlab=tmp.xlab, ylab=tmp.ylab,main=tmp.main)
            points(yy,xx,pch=".",col="green")
            points(newData[,k],x,pch=".",col="yellow")
            abline(0,1,col="red")
            Sys.sleep(2)
            plot(y,newData[,k],col="black",main="After normalization",pch=".",xlab=tmp.xlab,ylab=tmp.ylab)
            abline(0,1,col="red")
            Sys.sleep(2)
          }
        }
      }
    if (log.it) {
      return(2^newData)
    }
    else return(newData)
}

loess.normalize <- function (mat, subset = sample(1:(dim(mat)[2]), 5000), epsilon = 10^-2, 
    maxit = 1, log.it = TRUE, verbose = TRUE, span = 2/3, family.loess = "symmetric") 
{
    J <- dim(mat)[2]
    II <- dim(mat)[1]
    newData <- mat
    if (log.it) {
        mat <- log2(mat)
        newData <- log2(newData)
    }
    change <- epsilon + 1
    fs <- matrix(0, II, J)
    iter <- 0
    w <- c(0, rep(1, length(subset)), 0)
    while (iter < maxit) {
        iter <- iter + 1
        means <- matrix(0, II, J)
        for (j in 1:(J - 1)) {
            for (k in (j + 1):J) {
                y <- newData[, j] - newData[, k]
                x <- (newData[, j] + newData[, k])/2
                index <- c(order(x)[1], subset, order(-x)[1])
                xx <- x[index]
                yy <- y[index]
                aux <- loess(yy ~ xx, span = span, degree = 1, 
                  weights = w, family = family.loess)
                aux <- predict(aux, data.frame(xx = x))/J
                means[, j] <- means[, j] + aux
                means[, k] <- means[, k] - aux
                if (verbose) 
                  cat("Done with", j, "vs", k, " in iteration ", 
                    iter, "\n")
            }
        }
        fs <- fs + means
        newData <- mat - fs
        change <- max(apply((means[subset, ])^2, 2, mean))
        if (verbose) 
            cat("After ",iter, " iterations, change = ", change, "\n")
        oldfs <- fs
    }
    if (change > epsilon & maxit > 1) 
        warning(paste("No convergence after", maxit, "iterations.\n"))
    if (log.it) 
        return(2^newData)
    else return(newData)
}
