normalize.AffyBatch.invariantsetsubset <- function(abatch, prd.td=c(0.003,0.007), progress=TRUE, stable.probes) {
  # stable.probes is a list of the Affy probe sets which are unchanging. 
  require(modreg, quietly=TRUE)
  # get the indices of the probes within the stable.probes list
  w.pm <- unlist(indexProbes(abatch, which="pm")[stable.probes])
  # boolean to find the PM probes with the right probe set id's
  i.pm <- rep(FALSE, abatch@nrow * abatch@ncol)
  i.pm[w.pm] <- TRUE
  rm(w.pm)
  
  # number of PM probes
  np <- sum(i.pm)
  # number of CEL files
  nc  <-  length(abatch)
  
  # take as a reference the array having the median overall intensity
  m <- vector("numeric", length=nc)
  for (i in 1:nc)
    m[i] <- mean(intensity(abatch)[, i][i.pm])
  refindex <- trunc(median(rank(m)))
  rm(m)
  if (progress) cat("Data from", refindex, "used as baseline.\n")
  i.index <- which(i.pm)
  
  ## set.na.spotsd(cel.container)
  ## loop over the CEL files and normalize them
  for (i in (1:nc)[-refindex]) {
    if (progress) cat("normalizing array", i, "...")
    ## temporary
    x.label <- paste("Log2(intensity),chip ",refindex,sep="")
    y.label <- paste("Log2(intensity),chip ",i,sep="")
    plot(log2(intensity(abatch)[,refindex]),log2(intensity(abatch)[,i]),pch=".",xlab=x.label,ylab=y.label,main="Before normalization")
    points(log2((intensity(abatch)[,refindex])[i.pm]),log2((intensity(abatch)[,i])[i.pm]),pch=".",col="green")
    i.low <- order(intensity(abatch)[,i])[1]
    i.high <- order(-intensity(abatch)[,i])[1]
    i.fit <- c(i.index,i.low,i.high)
    tmp <- normalize.invariantsetsubset(c(intensity(abatch)[, i])[i.fit],
                                  c(intensity(abatch)[, refindex])[i.fit],
                                  prd.td)
    i.set <- which(i.pm)[tmp$i.set]
    points(log2((intensity(abatch)[,refindex])[i.set]),log2((intensity(abatch)[,i])[i.set]),col="yellow",pch=".")
    #tmp <- as.numeric(approx(tmp$n.curve$y, tmp$n.curve$x,
    #                         xout=intensity(abatch)[, i], rule=2)$y)
    #tmp.a <- as.numeric(approx(tmp$n.curve$x, tmp$n.curve$y,
    #                         xout=intensity(abatch)[, refindex], rule=2)$y)
    #tmp.a <- as.numeric(predict(tmp$n.curve, newdata = data.frame(xx=
    #                         intensity(abatch)[, refindex])))
    tmp.a <- as.numeric(predict(tmp$n.curve, newdata = data.frame(xx=
                             intensity(abatch)[, i])))
    #points(log2(intensity(abatch)[,refindex]),log2(tmp.a),col="red",pch=".")
    points(log2(tmp.a),log2(intensity(abatch)[,i]),col="red",pch=".")
    attr(tmp,"invariant.set") <- NULL
    intensity(abatch)[, i] <- tmp.a
    #intensity(abatch)[, i] <- intensity(abatch)[,i] + intensity(abatch)[,refindex] - tmp.a
    plot(log2(intensity(abatch)[,refindex]),log2(intensity(abatch)[,i]),pch=".",xlab=x.label,ylab=y.label,main="After normalization")
    points(log2((intensity(abatch)[,refindex])[i.set]),log2((intensity(abatch)[,i])[i.set]),col="yellow",pch=".")
    abline(0,1,col="red")
    Sys.sleep(2)
    ## storing information about what has been done
    ## history(abatch)[[i]] <- list(name="normalized by invariant set",
    ##                                    invariantset=i.set)
    if (progress) cat("done.\n")
    if (progress) cat("Number in invariant set: ",length(i.set),"\n",sep="")
  }
  ##history(abatch)[[refindex]] <- list(name="reference for the invariant set")
  return(abatch)
}

normalize.invariantsetsubset <- function (data, ref, prd.td = c(0.003, 0.007)) 
{
    np <- length(data)
    r.ref <- rank(ref)
    r.array <- rank(data)
    prd.td.adj <- prd.td * 10
    i.set <- rep(TRUE, np)
    ns <- sum(i.set)
    ns.old <- ns + 50 + 1
    while ((ns.old - ns) > 50) {
        air <- (r.ref[i.set] + r.array[i.set])/(2 * ns)
        prd <- abs(r.ref[i.set] - r.array[i.set])/ns
        threshold <- (prd.td.adj[2] - prd.td[1]) * air + prd.td.adj[1]
        i.set[i.set] <- (prd < threshold)
        ns.old <- ns
        ns <- sum(i.set)
        if (prd.td.adj[1] > prd.td[1]) 
            prd.td.adj <- prd.td.adj * 0.9
    }
    i.set[(np-1):np] <- TRUE
    w.set <- c(rep(1,times=(length(which(i.set))-2)),0,0)
    # set up a loess fit instead of the original smooth.spline function
    # which seemed to deviate from the data at low intensities.
    #n.curve <- loess(data[i.set] ~ ref[i.set],span=1/25,family="symmetric")
    n.curve <- loess(ref[i.set] ~ data[i.set],weights=w.set,span=1/25,family="symmetric")
    return(list(n.curve = n.curve, i.set = i.set))
}
