normalize.AffyBatch.constantsubset <- function(abatch, refindex=1, FUN=mean, na.rm=TRUE, stable.probes) {

  n <- length( abatch )
  stable.indices <- unlist(indexProbes(abatch,which="both")[stable.probes])
  print("Got stable indices...")
  if (! (refindex %in% 1:n)) stop("invalid reference index for normalization")
  refconstant <- FUN(intensity(abatch)[stable.indices,refindex], na.rm=na.rm)
  
  #set.na.spotsd(abatch)
                             
  for (i in (1:n)[-refindex]) {
    m <- normalize.constantsubset(intensity(abatch)[,i], refconstant, FUN=FUN, na.rm=na.rm, stable.indices=stable.indices)
    myhistory <- list(name="normalized by constant",
                      constant=attr(m,"constant"))
    attr(m,"constant") <- NULL
    intensity(abatch)[, i] <- m
    ##history(abatch)[[i]] <- myhistory
  }
  return(abatch)
}       

normalize.AffyBatch.constantsubsetpm <- function(abatch, refindex=1, FUN=mean, na.rm=TRUE, stable.probes) {

  n <- length( abatch )
  stable.indices <- unlist(indexProbes(abatch,which="pm")[stable.probes])
  print("Got stable indices...")
  if (! (refindex %in% 1:n)) stop("invalid reference index for normalization")
  refconstant <- FUN(intensity(abatch)[stable.indices,refindex], na.rm=na.rm)
  
  for (i in (1:n)[-refindex]) {
    m <- normalize.constantsubset(intensity(abatch)[,i], refconstant, FUN=FUN, na.rm=na.rm, stable.indices=stable.indices)
    myhistory <- list(name="normalized by constant",
                      constant=attr(m,"constant"))
    attr(m,"constant") <- NULL
    intensity(abatch)[, i] <- m
    ##history(abatch)[[i]] <- myhistory
  }
  return(abatch)
}       

normalize.AffyBatch.constantpm <- function(abatch, refindex=1, FUN=mean, na.rm=TRUE) {

  n <- length( abatch )
  stable.indices <- unlist(indexProbes(abatch,which="pm"))
  print("Got PM indices...")
  if (! (refindex %in% 1:n)) stop("invalid reference index for normalization")
  refconstant <- FUN(intensity(abatch)[stable.indices,refindex], na.rm=na.rm)

  for (i in (1:n)[-refindex]) {
    m <- normalize.constantsubset(intensity(abatch)[,i], refconstant, FUN=FUN, na.rm=na.rm, stable.indices=stable.indices)
    myhistory <- list(name="normalized by constant",
                      constant=attr(m,"constant"))
    attr(m,"constant") <- NULL
    intensity(abatch)[, i] <- m
    ##history(abatch)[[i]] <- myhistory
  }
  return(abatch)
}       

normalize.constantsubset <- function(x, refconstant, FUN=mean, na.rm=TRUE, stable.indices) {
  thisconstant <- FUN(x[stable.indices], na.rm=na.rm)
  r <- x / thisconstant * refconstant
  attr(r,"constant") <- thisconstant * refconstant
  return(r)
}

