library(affy)

# now do the bg correction and quantile normalization separately in order
# to save time.
load("../data.affybatch/data.orig")
data.mas <- bg.correct(data,method="mas")
data.mas.q <- normalize.AffyBatch.quantiles(data.mas)
save(data.mas.q,file="../data.affybatch/data.mas.q")
#save(data.mas,file="../data.affybatch/data.mas")
rm(data.mas,data.mas.q)
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.orig")
data.rma <- bg.correct(data,method="rma")
data.rma.q <- normalize.AffyBatch.quantiles(data.rma,type="pmonly")
#save(data.rma,file="../data.affybatch/data.rma")
save(data.rma.q,file="../data.affybatch/data.rma.q")
rm(data.rma.q,data.rma)
rm(data)
if(exists("last.warning")) { warnings() }

#now generate the expression indices.
load("../data.affybatch/data.rma.q")
expression <- expresso(data.rma.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/3c.txt")
save(expression,file="../data.expression/3c.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.rma.q")
expression <- expresso(data.rma.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/4c.txt")
save(expression,file="../data.expression/4c.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.rma.q")
expression <- expresso(data.rma.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/5c.txt")
save(expression,file="../data.expression/5c.dat")
if(exists("last.warning")) { warnings() }

# now start the expression indices which involve MAS background subtraction.
load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/6c.txt")
save(expression,file="../data.expression/6c.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/7c.txt")
save(expression,file="../data.expression/7c.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/8c.txt")
save(expression,file="../data.expression/8c.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/9c.txt")
save(expression,file="../data.expression/9c.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/10c.txt")
save(expression,file="../data.expression/10c.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/11c.txt")
save(expression,file="../data.expression/11c.dat")
if(exists("last.warning")) { warnings() }

# had lots of negative values and error messages.
load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/12c.txt")
save(expression,file="../data.expression/12c.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/13c.txt")
save(expression,file="../data.expression/13c.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/14c.txt")
save(expression,file="../data.expression/14c.dat")
if(exists("last.warning")) { warnings() }

sink(type="message")
sink()
