library(affy)

normalize.AffyBatch.methods <- c(normalize.AffyBatch.methods,"quantilesubset")
source("normalize.quantilesubset.R")

load("../data.mapping/mapping.unique")
spiked.probes <- names(mapping.unique)[mapping.unique == -2 | mapping.unique > 0]


# now do the bg correction and quantilesubset normalization separately in order
# to save time.
load("../data.affybatch/data.orig")
data.mas <- bg.correct(data,method="mas")
data.mas.qs <- normalize.AffyBatch.quantilesubset(data.mas,spiked.probes=spiked.probes)
save(data.mas.qs,file="../data.affybatch/data.mas.qs")
#save(data.mas,file="../data.affybatch/data.mas")
rm(data.mas,data.mas.qs)
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.orig")
data.rma <- bg.correct(data,method="rma")
data.rma.qs <- normalize.AffyBatch.quantilesubset(data.rma,pmonly=TRUE,spiked.probes=spiked.probes)
#save(data.rma,file="../data.affybatch/data.rma")
save(data.rma.qs,file="../data.affybatch/data.rma.qs")
rm(data.rma.qs,data.rma)
rm(data)
if(exists("last.warning")) { warnings() }

#now generate the expression indices.
load("../data.affybatch/data.rma.qs")
expression <- expresso(data.rma.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/3e.txt")
save(expression,file="../data.expression/3e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.rma.qs")
expression <- expresso(data.rma.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/4e.txt")
save(expression,file="../data.expression/4e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.rma.qs")
expression <- expresso(data.rma.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/5e.txt")
save(expression,file="../data.expression/5e.dat")
if(exists("last.warning")) { warnings() }

# now start the expression indices which involve MAS background subtraction.
load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/6e.txt")
save(expression,file="../data.expression/6e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/7e.txt")
save(expression,file="../data.expression/7e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/8e.txt")
save(expression,file="../data.expression/8e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="mas",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/9e.txt")
save(expression,file="../data.expression/9e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="mas",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/10e.txt")
save(expression,file="../data.expression/10e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="mas",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/11e.txt")
save(expression,file="../data.expression/11e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/12e.txt")
save(expression,file="../data.expression/12e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="subtractmm",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/13e.txt")
save(expression,file="../data.expression/13e.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="subtractmm",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/14e.txt")
save(expression,file="../data.expression/14e.dat")
if(exists("last.warning")) { warnings() }

sink(type="message")
sink()
