# make new 12 datasets which do not have so many errors due to negative expression values.
library(affy)

# don't really need to create a custom function because I can specify in the
# "na.rm=TRUE" parameter in the expresso function.
# generateExprVal.methods <- c(generateExprVal.methods, "medianpolishna")
# source("summary.medpolish.R")

# the following are already normalized and so we just do the subtractmm
# and medianpolishna steps.

stable.probes <- c()

load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    summary.param=list(na.rm=TRUE),
    verbose = TRUE)
save(expression,file="../data.expression/12a-na.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    summary.param=list(na.rm=TRUE),
    verbose = TRUE)
save(expression,file="../data.expression/12b-na.dat")

load("../data.affybatch/data.mas.q")
expression <- expresso(data.mas.q,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    summary.param=list(na.rm=TRUE),
    verbose = TRUE)
save(expression,file="../data.expression/12c-na.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    summary.param=list(na.rm=TRUE),
    verbose = TRUE)
save(expression,file="../data.expression/12d-na.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.qs")
expression <- expresso(data.mas.qs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    summary.param=list(na.rm=TRUE),
    verbose = TRUE)
save(expression,file="../data.expression/12e-na.dat")
if(exists("last.warning")) { warnings() }

sink(type="message")
sink()
