# this is to normalize against the 1x as well as 0x sets using loess set normalization...
library(affy)

# need to specify to affy the name of the new function.
normalize.AffyBatch.methods <- c(normalize.AffyBatch.methods,"loesssubset","loesssubsetpm","loesspm")
source("normalize.loesssubset.R")

load("../data.mapping/mapping.unique")
stable.probes <- names(mapping.unique)[mapping.unique == -1 | mapping.unique == 1]
# 1344 probes are changing in some way.

# need to use loesspm because the MM probes are not corrected by RMA bg.correction.
load("../data.affybatch/data.orig")
expression <- expresso(data,
    bg.correct=TRUE,bgcorrect.method="rma",
    normalize=TRUE,normalize.method="loesspm",
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/1b.txt")
save(expression,file="../data.expression/1b.dat")

# this one is probably OK
load("../data.affybatch/data.orig")
expression <- expresso(data,
    bg.correct=TRUE,bgcorrect.method="mas",
    normalize=TRUE,normalize.method="loess",
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/2b.txt")
save(expression,file="../data.expression/2b.dat")

# now do the bg correction and loesssubset normalization separately in order
# to save time.
load("../data.affybatch/data.orig")
data.mas <- bg.correct(data,method="mas")
data.mas.lss <- normalize.AffyBatch.loesssubset(data.mas,stable.probes)
save(data.mas.lss,file="../data.affybatch/data.mas.lss")
save(data.mas,file="../data.affybatch/data.mas")
rm(data.mas,data.mas.lss)

load("../data.affybatch/data.orig")
data.rma <- bg.correct(data,method="rma")
data.rma.lss <- normalize.AffyBatch.loesssubsetpm(data.rma,stable.probes)
save(data.rma,file="../data.affybatch/data.rma")
save(data.rma.lss,file="../data.affybatch/data.rma.lss")
rm(data.rma.lss,data.rma)
rm(data)

#now generate the expression indices.
load("../data.affybatch/data.rma.lss")
expression <- expresso(data.rma.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/3b.txt")
save(expression,file="../data.expression/3b.dat")

load("../data.affybatch/data.rma.lss")
expression <- expresso(data.rma.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/4b.txt")
save(expression,file="../data.expression/4b.dat")

load("../data.affybatch/data.rma.lss")
expression <- expresso(data.rma.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/5b.txt")
save(expression,file="../data.expression/5b.dat")

# now start the expression indices which involve MAS background subtraction.
load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/6b.txt")
save(expression,file="../data.expression/6b.dat")

load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/7b.txt")
save(expression,file="../data.expression/7b.dat")

load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/8b.txt")
save(expression,file="../data.expression/8b.dat")

load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/9b.txt")
save(expression,file="../data.expression/9b.dat")

load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/10b.txt")
save(expression,file="../data.expression/10b.dat")

load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/11b.txt")
save(expression,file="../data.expression/11b.dat")

# had lots of negative values and error messages.
load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/12b.txt")
save(expression,file="../data.expression/12b.dat")

load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/13b.txt")
save(expression,file="../data.expression/13b.dat")

load("../data.affybatch/data.mas.lss")
expression <- expresso(data.mas.lss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/14b.txt")
save(expression,file="../data.expression/14b.dat")

sink(type="message")
sink()
