# create new datasets where a final "loess" fit is made on the expression data.
# these are stored in the subdirectory data.expression.2 as simple matrices.

library(affy)
source("normalize.loesssubset.R")
load("../data.mapping/mapping.unique")
stable.probes <- names(mapping.unique)[mapping.unique == 1 | mapping.unique == -1]
ordered.probesets <- (names(mapping.unique))[order(names(mapping.unique))]
stable.index <- which(is.element(ordered.probesets,stable.probes))

list.nodats <- as.vector(read.delim("analyses.unix-na")[,2])
list.bg <- as.vector(read.delim("analyses.unix-na")[,5])
list.nodats <- list.nodats[list.bg != "subtractmm"]
list.nodats <- list.nodats[!is.element(list.nodats,c("dchip.1x","dchip.all","mas","perfectmatch"))]

#had to eliminate all the datasets with pmcorrect.method="subtractmm" because they caused an error.
for (i in list.nodats) {
  filename <- paste("../data.expression/",i,".dat",sep="")
  load(filename)
  expr <- expression@exprs
  gene.names <- geneNames(expression)
  tmp.order <- order(gene.names)
  if(length(which(gene.names[tmp.order] != ordered.probesets)) > 0) {
    cat("Error!\n");
  }
  stable.subset <- tmp.order[stable.index]
  if(max(expr,na.rm=TRUE) < 30) {
    log.it <- FALSE
  }
  else {
    log.it <- TRUE
  }
  cat("got to here\n")
  expr.norm <- normalize.loesssubset(expr,subset = stable.subset,log.it = log.it,span=1/10,sample.length=5000)
  filename <- paste("../data.expression.2/",i,".dat",sep="")
  save(expr.norm,file=filename)
}

list.bg <- as.vector(read.delim("analyses.unix-na")[,5])
list.nodats <- as.vector(read.delim("analyses.unix-na")[,2])
# do these, 
list.nodats <- list.nodats[list.bg == "subtractmm"]


for (i in list.nodats) {
  filename <- paste("../data.expression/",i,".dat",sep="")
  load(filename)
  expr <- expression@exprs
  gene.names <- geneNames(expression)
  tmp.order <- order(gene.names)
  if(length(which(gene.names[tmp.order] != ordered.probesets)) > 0) {
    cat("Error!\n");
  }
  stable.subset <- tmp.order[stable.index]
  if(max(expr,na.rm=TRUE) < 30) {
    log.it <- FALSE
  }
  else {
    log.it <- TRUE
  }
  cat("got to here\n")
  expr.norm <- normalize.loesssubset.new(expr,subset = stable.subset,log.it = log.it,span=1/2)
  filename <- paste("../data.expression.2/",i,".dat",sep="")
  save(expr.norm,file=filename)
}
