# this is to normalize against the 1x as well as 0x sets using rankinvariant set normalization...
library(affy)
# now create a sink for all output (error as well as normal output)
normalize.AffyBatch.methods <- c(normalize.AffyBatch.methods,"invariantsetsubset")
source("normalize.invariantsetsubset.R")

load("../data.mapping/mapping.unique")
stable.probes <- names(mapping.unique)[mapping.unique == -1 | mapping.unique == 1]
# 1344 probes are changing in some way.

load("../data.affybatch/data.orig")
expression <- expresso(data,
    bg.correct=TRUE,bgcorrect.method="rma",
    normalize=TRUE,normalize.method="invariantset",
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/1d.txt")
save(expression,file="../data.expression/1d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.orig")
expression <- expresso(data,
    bg.correct=TRUE,bgcorrect.method="mas",
    normalize=TRUE,normalize.method="invariantset",
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/2d.txt")
save(expression,file="../data.expression/2d.dat")
if(exists("last.warning")) { warnings() }

# now do the bg correction and constantsubset normalization separately in order
# to save time.
# save all the images in the following postscript file.
postscript("commands.invar2.ps",onefile=TRUE,points=18,width=8.5,height=8.5)

load("../data.affybatch/data.mas")
data.mas.iss <- normalize.AffyBatch.invariantsetsubset(data.mas,stable.probes=stable.probes)
save(data.mas.iss,file="../data.affybatch/data.mas.iss")
rm(data.mas,data.mas.iss)
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.rma")
data.rma.iss <- normalize.AffyBatch.invariantsetsubset(data.rma,stable.probes=stable.probes)
save(data.rma.iss,file="../data.affybatch/data.rma.iss")
rm(data.rma.iss,data.rma)
rm(data)
if(exists("last.warning")) { warnings() }

dev.off()

#now generate the expression indices.
load("../data.affybatch/data.rma.iss")
expression <- expresso(data.rma.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/3d.txt")
save(expression,file="../data.expression/3d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.rma.iss")
expression <- expresso(data.rma.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/4d.txt")
save(expression,file="../data.expression/4d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.rma.iss")
expression <- expresso(data.rma.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/5d.txt")
save(expression,file="../data.expression/5d.dat")
if(exists("last.warning")) { warnings() }

# now start the expression indices which involve MAS background subtraction.
load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/6d.txt")
save(expression,file="../data.expression/6d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/7d.txt")
save(expression,file="../data.expression/7d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/8d.txt")
save(expression,file="../data.expression/8d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/9d.txt")
save(expression,file="../data.expression/9d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/10d.txt")
save(expression,file="../data.expression/10d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/11d.txt")
save(expression,file="../data.expression/11d.dat")
if(exists("last.warning")) { warnings() }

# had lots of negative values and error messages.
load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/12d.txt")
save(expression,file="../data.expression/12d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/13d.txt")
save(expression,file="../data.expression/13d.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.iss")
expression <- expresso(data.mas.iss,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/14d.txt")
save(expression,file="../data.expression/14d.dat")
if(exists("last.warning")) { warnings() }

sink(type="message")
sink()

