library(affy)

# now create a sink for all output (error as well as normal output)
normalize.AffyBatch.methods <- c(normalize.AffyBatch.methods,"constantsubset","constantsubsetpm","constantpm")
source("normalize.constantsubset.R")

load("../data.mapping/mapping.unique")
stable.probes <- names(mapping.unique)[mapping.unique == 1]
# 1344 probes are changing in some way.

# need to use constantpm normalization because the RMA background subtraction method only corrects PM values, and MM values become invalidated.
load("../data.affybatch/data.orig")
expression <- expresso(data,
    bg.correct=TRUE,bgcorrect.method="rma",
    normalize=TRUE,normalize.method="constantpm",
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/1a.txt")
save(expression,file="../data.expression/1a.dat")
if(exists("last.warning")) { warnings() }

# this one is probably OK
load("../data.affybatch/data.orig")
expression <- expresso(data,
    bg.correct=TRUE,bgcorrect.method="mas",
    normalize=TRUE,normalize.method="constant",
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/2a.txt")
save(expression,file="../data.expression/2a.dat")
if(exists("last.warning")) { warnings() }

# now do the bg correction and constantsubset normalization separately in order
# to save time.
load("../data.affybatch/data.orig")
data.mas <- bg.correct(data,method="mas")
data.mas.cs <- normalize.AffyBatch.constantsubset(data.mas,stable.probes=stable.probes)
save(data.mas.cs,file="../data.affybatch/data.mas.cs")
#save(data.mas,file="data.mas")
rm(data.mas,data.mas.cs)
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.orig")
data.rma <- bg.correct(data,method="rma")
data.rma.cs <- normalize.AffyBatch.constantsubsetpm(data.rma,stable.probes=stable.probes)
#save(data.rma,file="data.rma")
save(data.rma.cs,file="../data.affybatch/data.rma.cs")
rm(data.rma.cs,data.rma)
rm(data)
if(exists("last.warning")) { warnings() }

#now generate the expression indices.
load("../data.affybatch/data.rma.cs")
expression <- expresso(data.rma.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/3a.txt")
save(expression,file="../data.expression/3a.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.rma.cs")
expression <- expresso(data.rma.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/4a.txt")
save(expression,file="../data.expression/4a.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.rma.cs")
expression <- expresso(data.rma.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/5a.txt")
save(expression,file="../data.expression/5a.dat")
if(exists("last.warning")) { warnings() }

# now start the expression indices which involve MAS background subtraction.
load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/6a.txt")
save(expression,file="../data.expression/6a.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/7a.txt")
save(expression,file="../data.expression/7a.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="pmonly",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/8a.txt")
save(expression,file="../data.expression/8a.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/9a.txt")
save(expression,file="../data.expression/9a.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/10a.txt")
save(expression,file="../data.expression/10a.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="mas",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/11a.txt")
save(expression,file="../data.expression/11a.dat")
if(exists("last.warning")) { warnings() }

# had lots of negative values and error messages.
load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="medianpolish",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/12a.txt")
save(expression,file="../data.expression/12a.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="mas",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/13a.txt")
save(expression,file="../data.expression/13a.dat")
if(exists("last.warning")) { warnings() }

load("../data.affybatch/data.mas.cs")
expression <- expresso(data.mas.cs,
    bg.correct=FALSE,bgcorrect.method="none",
    normalize=FALSE,normalize.method="none",
    normalize.param=list(stable.probes=stable.probes),
    pmcorrect.method="subtractmm",
    summary.method="liwong",
    verbose = TRUE)
#write.exprs(expression,file="../data.expression/14a.txt")
save(expression,file="../data.expression/14a.dat")
if(exists("last.warning")) { warnings() }

sink(type="message")
sink()
