# generate the CyberT test statistics
library(affy)
library(goldenspike)

files <- list.files(path="../data.expression",pattern="*.dat")

for (file in files) {
  load(paste("../data.expression/",file,sep=""))
  expr <- expression@exprs
  expr <- prepare.expr(expr,log.it=TRUE,cutoff.value=-3)
  res <- pierre.unpair.element(expr,1:3,4:6,100,10,2)
  save(res,file=paste("../data.cybert/",file,sep=""))
  cat("Done with",file,"\n")
}

files <- list.files(path="../data.expression.2",pattern="*.dat")

for (file in files) {
  load(paste("../data.expression.2/",file,sep=""))
  expr.norm <- prepare.expr(expr.norm,log.it=TRUE,cutoff.value=-3)
  res <- pierre.unpair.element(expr.norm,1:3,4:6,100,10,2)
  save(res,file=paste("../data.cybert.2/",file,sep=""))
  cat("Done with",file,"\n")
}
