# generate the data to make the receiver-operator characteristics curves in figure 7.

library(goldenspike)
load("../data.mapping/mapping.unique")
pos.fc.affy <- names(mapping.unique)[mapping.unique > 1.1]
num.positives <- length(pos.fc.affy)
neg.fc.affy <- names(mapping.unique)[mapping.unique == 1 | mapping.unique == -1]

files <- list.files(path="../data.cybert",pattern="*.dat")
for (file in files) {
  load(paste("../data.cybert/",file,sep=""))
  scores <- abs(res$Bay.t)
  gene.names <- rownames(res)
  positives <- which(is.element(gene.names,pos.fc.affy))
  negatives <- which(is.element(gene.names,neg.fc.affy))
  ro <- make.ro(positives,negatives,scores,length.mat=500)
  save(ro,file=paste("../data.cybert-ro/",file,sep=""))
  cat("Done with",file,"\n")
}

files <- list.files(path="../data.cybert.2",pattern="*.dat")
for (file in files) {
  load(paste("../data.cybert.2/",file,sep=""))
  scores <- abs(res$Bay.t)
  gene.names <- rownames(res)
  positives <- which(is.element(gene.names,pos.fc.affy))
  negatives <- which(is.element(gene.names,neg.fc.affy))
  ro <- make.ro(positives,negatives,scores,length.mat=500)
  save(ro,file=paste("../data.cybert-ro.2/",file,sep=""))
  cat("Done with",file,"\n")
}
