# generate figure 7 from the genome biology manuscript.
# the expression summary datasets that were generated outside of R are
# not included here.

analysis <- read.delim("../scripts.make.exprs/analyses.unix-na")
dat.names <- as.vector(analysis$dat.file)
dat.names <- intersect(dat.names,list.files(path="../data.expression",pattern=".dat"))


postscript("command-fig7.eps",onefile=FALSE,horizontal=FALSE,height=8,width=7.5,points=12)
layout(matrix(1:12,nrow=3,ncol=4,byrow=TRUE),widths=c(10,5,10,5))

# A: Do second normalization
par(mar=c(3.5,2.5,0.1,0.1),mgp=c(1.5,0.5,0))
plot(c(-1),c(-1),pch=".",xlab="False discovery rate",ylab="Fraction of true positives found",xlim=c(0,0.5),ylim=c(0,1))
grid(lty=1,lwd=1)
for (i in dat.names) {
  file.ro <- paste("../data.cybert-ro.2/",i,sep="")
  load(file.ro)
  lines(ro$x/ro$called.positive,ro$y/ro$num.positive,col="deepskyblue2",lwd=1)
}
for (i in dat.names) {
  file.ro <- paste("../data.cybert-ro/",i,sep="")
  load(file.ro)
  lines(ro$x/ro$called.positive,ro$y/ro$num.positive,col="darkorange",lwd=1)
}
text(0.02,0.98,"A",cex=2)
par(mar=c(0.1,0.1,0.1,0.1))
plot(-1,-1,xaxt="n",yaxt="n",bty="n",xlim=c(0,1),ylim=c(0,1))
legend(0,0.7,legend=c("none","loesssubset"),fill=c("darkorange","deepskyblue2"),x.intersp=0.5)

#B: BG correction

bg.correct.types <- as.vector(analysis$bg.correct[is.element(analysis$dat.file,dat.names)])
bg.correct.types <- levels(factor(bg.correct.types))
bg.correct.types
#[1] "mas" "rma"
par(mar=c(3.5,2.5,0.1,0.1),mgp=c(1.5,0.5,0))
tmp.col <- c("steelblue2","violetred3")
plot(c(-1),c(-1),pch=".",xlab="False discovery rate",ylab="Fraction of true positives found",xlim=c(0,0.5),ylim=c(0,1))
grid(lty=1,lwd=1)
for (i in 1:2) {
  tmp.names <- as.vector(analysis$dat.file)[as.vector(analysis$bg.correct) == bg.correct.types[i]]
  tmp.names <- intersect(tmp.names,dat.names)
  for(j in tmp.names) {
    load(paste("../data.cybert-ro.2/",j,sep=""))
    lines(ro$x/ro$called.positive,ro$y/ro$num.positive,col=tmp.col[i],lwd=1)
  }
}
text(0.02,0.98,"B",cex=2)
par(mar=c(0.1,0.1,0.1,0.1))
plot(-1,-1,xaxt="n",yaxt="n",bty="n",xlim=c(0,1),ylim=c(0,1))
legend(0,0.7,legend=bg.correct.types,fill=tmp.col)

# C: Normalization methods
normalize.types <- as.vector(analysis$normalize[is.element(analysis$dat.file,dat.names)])
normalize.types <- levels(factor(normalize.types))
normalize.types
#[1] "constant"           "constantsubset"     "invariantset"      
#[4] "invariantsetsubset" "loess"              "loesssubset"       
#[7] "quantiles"          "quantilesubset"    

#layout.show(2)
par(mar=c(3.5,2.5,0.1,0.1),mgp=c(1.5,0.5,0))
tmp.col <- c("steelblue2","steelblue2","violetred3","violetred3","darkgreen","darkgreen","yellow","yellow")
plot(c(-1),c(-1),pch=".",xlab="False discovery rate",ylab="Fraction of true positives found",xlim=c(0,0.5),ylim=c(0,1))
grid(lty=1,lwd=1)
for (i in 1:8) {
  tmp.names <- as.vector(analysis$dat.file)[as.vector(analysis$normalize) == normalize.types[i]]
  tmp.names <- intersect(tmp.names,dat.names)
  for(j in tmp.names) {
    load(paste("../data.cybert-ro.2/",j,sep=""))
    lines(ro$x/ro$called.positive,ro$y/ro$num.positive,col=tmp.col[i],lwd=1)
  }
}
text(0.02,0.98,"C",cex=2)
par(mar=c(0.1,0.1,0.1,0.1))
plot(-1,-1,xaxt="n",yaxt="n",bty="n",xlim=c(0,1),ylim=c(0,1))
legend(0,0.9,legend=normalize.types,fill=tmp.col,x.intersp=0.2)

# D: PM correction
pm.correct.types <- as.vector(analysis$mm.subtract[is.element(analysis$dat.file,dat.names)])
pm.correct.types <- levels(factor(pm.correct.types))
pm.correct.types
# [1] "mas"        "pmonly"     "subtractmm"
par(mar=c(3.5,2.5,0.1,0.1),mgp=c(1.5,0.5,0))
tmp.col <- c("steelblue2","seagreen","violetred3")
plot(c(-1),c(-1),pch=".",xlab="False discovery rate",ylab="Fraction of true positives found",xlim=c(0,0.5),ylim=c(0,1))
grid(lty=1,lwd=1)
for (i in 1:3) {
  tmp.names <- as.vector(analysis$dat.file)[as.vector(analysis$mm.subtract) == pm.correct.types[i]]
  tmp.names <- intersect(tmp.names,dat.names)
  for(j in tmp.names) {
    load(paste("../data.cybert-ro.2/",j,sep=""))
    lines(ro$x/ro$called.positive,ro$y/ro$num.positive,col=tmp.col[i],lwd=1)
  }
}
text(0.02,0.98,"D",cex=2)
par(mar=c(0.1,0.1,0.1,0.1))
plot(-1,-1,xaxt="n",yaxt="n",bty="n",xlim=c(0,1),ylim=c(0,1))
legend(0,0.7,legend=pm.correct.types,fill=tmp.col)

# E: Summary
summary.types <- as.vector(analysis$summary[is.element(analysis$dat.file,dat.names)])
summary.types <- levels(factor(summary.types))
summary.types
#[1] "liwong"         "mas"            "medianpolish"   "medianpolishna"

par(mar=c(3.5,2.5,0.1,0.1),mgp=c(1.5,0.5,0))
tmp.col <- c("cornflowerblue","violetred3","darkgreen","darkgreen")
plot(c(-1),c(-1),pch=".",xlab="False discovery rate",ylab="Fraction of true positives found",xlim=c(0,0.5),ylim=c(0,1))
grid(lty=1,lwd=1)
for (i in 1:4) {
  tmp.names <- as.vector(analysis$dat.file)[as.vector(analysis$summary) == summary.types[i]]
  tmp.names <- intersect(tmp.names,dat.names)
  for(j in tmp.names) {
    load(paste("../data.cybert-ro.2/",j,sep=""))
    lines(ro$x/ro$called.positive,ro$y/ro$num.positive,col=tmp.col[i],lwd=1)
  }
}
text(0.02,0.98,"E",cex=2)
par(mar=c(0.1,0.1,0.1,0.1))
plot(-1,-1,xaxt="n",yaxt="n",bty="n",xlim=c(0,1),ylim=c(0,1))
legend(0,0.9,legend=summary.types,fill=tmp.col,x.intersp=0.2)

# winners:
# bg correction: mas
# normalization: any (but probably quantile or constant)
# pm correction: mas
# summary: medianpolish or mas

success.names <- as.vector(analysis$dat.file)[as.vector(analysis$bg.correct) == "mas" & is.element(as.vector(analysis$summary),c("medianpolish","mas","medianpolishna")) & is.element(as.vector(analysis$mm.subtract),c("mas"))]
success.names <- intersect(success.names,dat.names)
par(mar=c(3.5,2.5,0.1,0.1),mgp=c(1.5,0.5,0))
plot(c(-1),c(-1),pch=".",xlab="False discovery rate",ylab="Fraction of true positives found",xlim=c(0,0.5),ylim=c(0,1))
grid(lty=1,lwd=1)
for (i in dat.names) {
  load(paste("../data.cybert-ro.2/",i,sep=""))
  lines(ro$x/ro$called.positive,ro$y/ro$num.positive,col="gray",lwd=1)
}
success.names
# [1] "9a"  "10a" "9b"  "10b" "9c"  "10c" "9d"  "10d" "9e"  "10e"
tmp.col <- c("deepskyblue1","darkorange","deepskyblue1","darkorange","deepskyblue1","darkorange","deepskyblue1","darkorange","deepskyblue1","darkorange")
for (i in 1:length(success.names)) {
  load(paste("../data.cybert-ro.2/",success.names[i],sep=""))
  lines(ro$x/ro$called.positive,ro$y/ro$num.positive,col=tmp.col[i],lwd=1)
}

text(0.02,0.98,"F",cex=2)
par(mar=c(0.1,0.1,0.1,0.1))
plot(-1,-1,xaxt="n",yaxt="n",bty="n",xlim=c(0,1),ylim=c(0,1))
legend(0,0.95,legend=success.names,fill=tmp.col)
dev.off()

