#!/usr/bin/perl -w

=head1 Description

    This script will add local rank info into the hits file.

=head1 Usage
    
    perl add.rank2hits.pl RankList HitsFile

    RankList    File that generated by ranking.hit.pl, it stores local rank info for each CRM at each gene
    HitsFIle    File taht generated from scoring schemes, it can be found in hits/ directory

=cut


use strict;
#use Bio::SeqIO;
die `pod2text $0` if (@ARGV != 2);

my $rank=$ARGV[0];
my $hits=$ARGV[1];
my %rank_crm;

open IN,$rank;
while (<IN>){
    chomp;
    my @a=split;
    $rank_crm{$a[1]}{$a[0]}=$a[3];
}
close IN;

#my $fo = Bio::SeqIO->new(-file=>$hits,-format=>'Fasta');
open FA,$hits;
$/ = ">";<FA>;$/= "\n";
#while (my $f = $fo->next_seq()){
while (<FA>){
    my $title = $_;
    #my $title= $f->id();
    $/ = ">";
    my $seq = <FA>;
    chomp $seq;
    $/ = "\n";
    chomp $seq;
    my @array=split /\s+|,/,$title;
    if ($rank_crm{$array[0]})
    {
        print ">$array[0]\t$array[1]\t";
        for my $gene_term (@array[2..$#array])
        {
            my $gene_id=(split /\:/,$gene_term)[0];
            if ($rank_crm{$array[0]}{$gene_id})
            {
                print "$gene_term:lr=$rank_crm{$array[0]}{$gene_id},";
            }
            else
            {
                print "$gene_term:lr=?,";
            }
        }
        print "\n$seq\n";
    }
}
close FA;
