library(limma)

targets = readTargets() # targets frame; default file name is Targets.txt
# read Agilent intensity data; by default, mean signal is used for foreground and median signal is used for background
RG = read.maimages(targets$FileName, source="agilent", path="raw") 
save(RG, file="test/Agilent.raw.RData", compress=T)
warnings()

# In read.maimages, when source="agilent", 
# G = "gMeanSignal", Gb = "gBGMedianSignal", R = "rMeanSignal", Rb = "rBGMedianSignal"
