library(limma)

bg.methods = c("none", "normexp", "rma")
withinnor.methods = c("none", "loess")
betweennor.methods = c("none", "quantile")

load("test/Agilent.raw.RData")
for (bg in bg.methods) {
	offset = 0
	if (bg == "normexp") offset = 50
	RGb = backgroundCorrect(RG, method=bg, offset=offset)
	for (wnor in withinnor.methods) {
		MA.w = normalizeWithinArrays(RGb, method=wnor)
		for (bnor in betweennor.methods) {
			cat(paste(bg, wnor, bnor), sep="\n")
			MA = normalizeBetweenArrays(MA.w, method=bnor)
			save(MA, file=paste("test/Agilent", bg, wnor, bnor, "RData", sep="."), compress=T)
		}
	}
}
warnings()
