library(limma)

targets = readTargets() # targets frame; default file name is Targets.txt
# read Agilent processed intensity data
RG = read.maimages(targets$FileName, path="raw", columns=list(R="rProcessedSignal",G="gProcessedSignal"), annotation=c("Row", "Col", "Start", "Sequence", "SwissProt", "GenBank", "Primate", "GenPept", "ProbeUID", "ControlType", "ProbeName", "GeneName", "SystematicName", "Description"))
# Note: annotation argument is set identical to the annotation argument used when source="agilent" in read.maimages 
MA = MA.RG(RG, bc.method="none") # convert RGlist to MAlist
save(MA, file="test/Agilent.FE.FE.FE.RData", compress=T)
warnings()

