options(warn=1)
library(limma)

targets = readTargets()
n = nrow(targets)
# Note: M = log2(R/G) = log2(Cy5/Cy3)
sign = rep(1, nrow(targets))
sign[grep("A", targets$Cy5)] = -1

bg.methods = c("none", "subtract", "normexp", "rma")
withinnor.methods = c("none", "loess")
betweennor.methods = c("none", "Aquantile", "quantile")
routes = apply(expand.grid(bg.methods, withinnor.methods, betweennor.methods), 1, function(x){paste(x, collapse=".")})
routes = c(routes, "FE.FE.FE")
for (r in routes) {
	cat(r, sep="\n")
	file = paste("/panasas/scratch/qzhu/microarray/Agilent/RData/Agilent", r, "RData", sep=".")
	load(file)
	M = apply(MA$M, 1, function(x){mean(x*sign)}) # mean M for B vs A
	fit = cbind(M, MA$genes$ControlType)
	rownames(fit) = MA$genes$ProbeName
	colnames(fit) = c("M", "ControlType") 
	save(fit, file=paste("/panasas/scratch/qzhu/microarray/Agilent/RData/Agilent", r, "fc", "RData", sep="."), compress=T)
}
