library(ROCR)

# Note: In ROCR, f(x) ≥ cutoff => class "+"; f(x) < cutoff => class "-". 
# Use abs(statistic) to evaluate DEGs: the higher value, the more likely to be DEGs.
# abs(statistic) >= cutoff => class "+" (DEGs) 
fcinfo = read.table("Agilentprobe.fcvalue", header=F)
truth = rep(NA, nrow(fcinfo))
# empty probesets are considered as not differentially expressed probesets 
truth[fcinfo$V2!=0 & fcinfo$V2 != "MC" & fcinfo$V2!="MF" & fcinfo$V2!="NS" & fcinfo$V2!=1] = 1 # differentially expressed probesets
truth[fcinfo$V2==1] = 0 # not differentially expressed probesets
truth[fcinfo$V2==0] = 0 # not differentially expressed probesets
names(truth) = fcinfo$V1
truth = truth[!is.na(truth)]

bg.methods = c("none", "normexp", "rma")
withinnor.methods = c("none", "loess")
betweennor.methods = c("none", "quantile")
DEG.methods = c("fc", "limma")
methods = apply(expand.grid(bg.methods, withinnor.methods, betweennor.methods), 1, function(x){paste(x, collapse=".")})
methods = c(methods, "FE.FE.FE")
methods = as.vector(mapply(function(x){paste(methods, x, sep=".")}, DEG.methods))

fpr.stop = 0.05 # AUC is the area under the curve when fpr <= fpr.stop
write.table(t(c("n", paste("AUC", fpr.stop, sep="_"))), file="test/DEGAUC.diag", append=F, row.names=F, col.names=F, quote=F, sep="\t")
for (m in methods) {
	cat(m, sep="\n")
	DEG.method = strsplit(m, "\\.")[[1]][4]
	file = paste("test/Agilent", m, "RData", sep=".")
	load(file)
	if (DEG.method == "limma") {
		ind = which(fit$genes$ControlType==0) # not control probes
		statistic = fit$t[ind,2]
		names(statistic) = fit$genes$ProbeName[ind]
	} else {
		if (DEG.method == "fc") {
			ind = which(fit[,2]==0) # not control probes
			statistic = fit[ind,1] # M for B vs A
			names(statistic) = rownames(fit)[ind]
		}
	}
	# the probesets that have expected fold change information
	index = which(is.na(match(names(statistic), names(truth))))
	statistic = statistic[-index]
	truth.tmp = truth[match(names(statistic), names(truth))]
	pred = prediction(predictions=abs(statistic), labels=truth.tmp)
	diag.stat = c(length(truth.tmp), mapply(function(x){attr(performance(pred, measure="auc", fpr.stop=x), "y.values")[[1]]}, fpr.stop))
	write.table(t(c(m, diag.stat)), file="test/DEGAUC.diag", append=T, row.names=F, col.names=F, quote=F, sep="\t")
}
warnings()
